<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\Therapist;
use App\Models\Slot;
use App\Models\UserReview;
use App\Models\Coupons;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use App\Models\WorkingHours;
use App\Models\SlotShedule;
use App\Models\TherapistCommission;
use App\Models\PaymentDetails;
use App\Models\Appointments;
use App\Models\Location;
use App\Models\ServiceFeeStructure;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use App\Models\WalletPoint;
use Illuminate\Support\Facades\DB;
use App\Notifications\AppoinmentNotification;
use App\Models\Admin;
use App\Models\WalletPointCommission;
use Illuminate\Support\Facades\Notification;
use App\Models\PushNotification;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;
use Razorpay\Api\Api;
use App\Models\Leave;
use Illuminate\Support\Facades\Mail;
use App\Mail\BookingMail;

class BookingController extends Controller
{

    public function getPackages(Request $request)
    {
        $data = [];
        $data['service_id'] = $request->service_id;
        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;

        $data['packages'] = [];
        $array = Package::select('id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('service_id', $request->service_id)->where('status', 'ACTIVE')->get();
        $pc = $request->provider_category_id;
        if ($array) {
            foreach ($array as $key => $item) {


                if ($item->service_fee_id != '' || $item->service_fee_id != NULL) {
                    $sfs = ServiceFeeStructure::whereIn('id', json_decode($item->service_fee_id))
                        ->where('provider_category_id', $pc)
                        ->where('service_id', $request->service_id)
                        ->with('callMethod')
                        ->get();


                    if (count($sfs) == 0) {
                        continue;
                    }
                    $data['packages'][$key]['id'] = $item->id;
                    $data['packages'][$key]['service_fee_id'] = $item->service_fee_id;
                    $data['packages'][$key]['title'] = $item->title;
                    $data['packages'][$key]['no_of_sessions'] = $item->no_of_sessions;
                    $data['packages'][$key]['discount'] = $item->discount;

                    $data['packages'][$key]['description'] = Str::limit((strip_tags($item->description)), 50, '...');
                    $data['packages'][$key]['description'] = preg_replace("/&nbsp;/", '', $item->description);
                    $data['packages'][$key]['description'] = preg_replace("/\s+/", " ", $item->description);
                    $data['packages'][$key]['image'] = asset('assets/uploads/package/') . '/' . $item->image;

                    $discount = $item->discount;
                    $data['packages'][$key]['communication_methods'] = collect($sfs->toArray())->map(function ($item2) use ($discount) {
                        $convertedAmount = round(CurrencyConverter::convert($item2['rate'])
                            ->from('INR')
                            ->to(auth()->user()->currency_code)
                            ->get(), 2);

                        $item['call_method_id'] = $item2['call_method_id'];
                        $item['call_method'] = $item2['call_method']['name'];
                        $item['actual_fee'] = $convertedAmount;
                        $subtotal = $convertedAmount * ($discount / 100);
                        $item['discount_fee'] = round($convertedAmount -  $subtotal, 2);
                        $item['currency'] = auth()->user()->currency_symbol;
                        $item['currency_code'] = auth()->user()->currency_code;
                        return $item;
                    });
                } else {
                    $data['packages'][$key]['communication_methods'] = [];
                }
            }
        }
        // $array['packages'] = collect($array['packages']->toArray())->map(function ($item) use ($pc) {

        //     $sfs = ServiceFeeStructure::whereIn('id', json_decode($item['service_fee_id']))->with('callMethod')->where('provider_category_id', $pc)->get();
        //     if (count($sfs) == 0) {
        //         return true;
        //     }
        //     $discount = $item['discount'];
        //     $item['communication_methods'] = collect($sfs->toArray())->map(function ($item2) use ($discount) {
        //         $item['call_method_id'] = $item2['call_method_id'];
        //         $item['call_method'] = $item2['call_method']['name'];
        //         $item['actual_fee'] = $item2['rate'];
        //         $subtotal = $item2['rate'] * ($discount / 100);
        //         $item['discount_fee'] = $item2['rate'] -  $subtotal;
        //         return $item;
        //     });

        //     $item['image'] = asset('assets/uploads/package/') . '/' . $item['image'];
        //     $item['description'] = Str::limit((strip_tags($item['description'])), 50, '...');
        //     $item['description'] = preg_replace("/&nbsp;/", '', $item['description']);
        //     $item['description'] = preg_replace("/\s+/", " ", $item['description']);
        //     return $item;
        // });

        // $data['packages'] = $array;
        $sfs = ServiceFeeStructure::where('service_id', $request->service_id)->where('provider_category_id', $request->provider_category_id)->get();

        foreach ($sfs as $key => $item) {
            $convertedAmount = round(CurrencyConverter::convert($item->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);
            $call_methods[$key] = [
                'id' => $item->callMethod->id,
                'name' => $item->callMethod->name,
                'fee' => $convertedAmount,
                'currency' => auth()->user()->currency_symbol,
                'currency_code' => auth()->user()->currency_code
            ];
        }

        $data['fee_structure'] = $call_methods;

        $item = collect($call_methods)->unique()->values();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function searchSlot(Request $request)
    {

        $current_date = date("Y-m-d");
        $current_time = date("H:i");
        $html = '';
        $data = [];
        $booking_date = date("Y-m-d", strtotime($request->bookingDate));
        $error = 'No slots Found';
        $day = Carbon::createFromFormat('Y-m-d', $request->bookingDate)->format('l');
        $service = $request->service;

        $slot = Slot::where('therapist_id', $request->therapist)->first();
        $leaves = Leave::where('therapist_id', $request->therapist)
            ->where('leave_from', '<=', $booking_date)
            ->where('leave_to', '>=', $booking_date)
            ->first();

        if ($leaves == null) {
            if ($slot) {
                $therapist_workinghours = WorkingHours::where('slot_id', $slot->id)
                    ->where('day', $day)
                    //  ->where('service_id', $service)
                    ->get();



                if (!empty($therapist_workinghours)) {
                    $i = 0;
                    $j = 0;
                    foreach ($therapist_workinghours as $workinghours) {

                        $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $request->callmethod)->first();

                        if ($slotlist) {

                            foreach (json_decode($slotlist->slots) as $key => $x) {
                                //***** */
                                $slot_flag = 0;
                                // $bookedslots = Appointments::where('therapist_id', $request->therapist)
                                //     ->where('Appointment_Date', $booking_date)
                                //     ->where('Appointment_Status', '!=', 'Failed')
                                //     ->where('Appointment_Status', '!=', 'Cancel')
                                //     ->get();
                                  $bookedslots = Appointments::where('therapist_id', $request->therapist)
                                ->where('Appointment_Date', $booking_date)
                                ->whereNotIn('Appointment_Status',['Rejected',  'Cancel', 'Failed'])
                                ->get();
                                if ($bookedslots) {
                                    foreach ($bookedslots as $bookedslot) {
                                        $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();

                                        if ($booked_slotlist) {

                                            $time1  = date("Y-m-d H:i", strtotime($bookedslot->Appointment_Date . $bookedslot->Appointment_Time));
                                            $givenTime = Carbon::parse($time1);
                                            $time1 = date("H:i", strtotime($givenTime->subHour()));



                                            $time2  = date("Y-m-d H:i", strtotime($bookedslot->end_datetime . $bookedslot->end_time));
                                            $givenTime = Carbon::parse($time2);
                                            $time2 = date("H:i", strtotime($givenTime->addMinutes($slot->break_duration)));

                                            //   $time2 = date("H:i", strtotime($bookedslot->end_time));
                                            // $time2 = date("H:i", strtotime($next_booked_slot));
                                            // $time3 = date("H:i", strtotime($prev));
                                            $checkedtime = date("H:i", strtotime($x));


                                            if ($checkedtime >= $time1 && $checkedtime < $time2) {
                                                //  if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {

                                                $slot_flag = 1;
                                                break;
                                            }
                                        }
                                    }
                                }
                                if ($slot_flag == 1) {

                                    continue;
                                }
                                //*** */
                                $givenDateTime = date("H:i", strtotime($x));


                                if ($current_date == $request->bookingDate) {

                                    if ($current_time < $givenDateTime) {

                                        $data[$i]['slot_id'] = $slotlist->id;
                                        $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                                        $data[$i]['slots'] = $x;
                                        if ($booked) {
                                            $data[$i]['slot_status'] = $booked->Appointment_Status;
                                        } else {
                                            $data[$i]['slot_status'] = 'Available';
                                        }
                                        $i++;
                                    }
                                } else {

                                    $data[$j]['slot_id'] = $slotlist->id;
                                    $booked = Appointments::where('slot_id', $slotlist->id)
                                    ->where('Appointment_Time', $x)
                                    ->where('Appointment_Date', $booking_date)
                                       ->whereNotIn('Appointment_Status',['Rejected',  'Cancel', 'Failed'])
                                    ->first();
                                    $data[$j]['slots'] = $x;
                                    if ($booked) {
                                        $data[$j]['slot_status'] = $booked->Appointment_Status;
                                    } else {
                                        $data[$j]['slot_status'] = 'Available';
                                    }
                                    $j++;
                                }
                            }
                        } else {

                            return response()->json(
                                array(
                                    'status' => False,
                                    'data' => $error
                                ),
                                200
                            );
                        }
                    }


                    return response()->json(
                        array(
                            'status' => True,
                            'data' => $data
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => False,
                            'data' => $error
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'data' => $error
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => "Therapist On Leave"
                ),
                200
            );
        }
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function packageBooking(Request $request)
    {

        $data = [];
        $call_methods = [];
        $grandtotal = 0;
        $array = Package::select('id', 'service_id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('id', $request->package_id)->first();
        $data = $array;
        $service_ids = json_decode($array->service_fee_id);
        $sfs = ServiceFeeStructure::whereIn('id', $service_ids)->where('provider_category_id', $request->provider_category)->first();

        if ($sfs) {
            $convertedAmount = round(CurrencyConverter::convert($sfs->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);

            $total = $convertedAmount * $array->no_of_sessions;
            $subtotal = $total * ($array->discount / 100);
            $grandtotal = $total - $subtotal;
            $data['communication_method_id'] = $sfs->callMethod->id;
            $data['communication_method'] = $sfs->callMethod->name;
            $data['actual_price'] = $convertedAmount;
            $data['discount_price'] = $grandtotal;
            $data['currency'] = auth()->user()->currency_symbol;
            $data['currency_code'] = auth()->user()->currency_code;
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function getCoupons(Request $request)
    {
        $date = date('Y-m-d', strtotime(Carbon::now()));
        // $data = Coupons::select('id', 'promo_code', 'discount_type', 'discount_rate')->where('start_date', '<=', $date)->Where('expiry_date', '>=', $date)->first();
        $data = DB::select("SELECT id, promo_code,discount_type, discount_rate,start_date,expiry_date FROM `coupons` WHERE `start_date` <= '2024-01-25' AND `expiry_date` >= '2024-01-25'");
        // print_r($data);
        // die();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function addCoupons(Request $request)
    {
        $total = 0;
        $data = Coupons::where('id', $request->coupon_code)->first();

        if ($data->discount_type == '%') {
            $total = $request->total * ($data->discount_rate / 100);
            $total = $request->total - $total;
        } else {
            $total = $request->total - $request->coupon_code;
        }
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $total
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

     public function bookAppoinment(Request $request)
    {

        $booking_date = date("Y-m-d", strtotime($request->booking_date));
        $dob = date("Y-m-d", strtotime($request->dob));
        $userWalletTransaction_id = NULL;
        $paymentid = NULL;
        $status = 'Unpaid';
        $lastID = Appointments::orderBy('id', 'DESC')->pluck('id')->first();
       
        $exist = Appointments::where('Appointment_Date', $booking_date)->where('slot_id', $request->slot_id)->where('Appointment_Time', $request->slot)->first();
         $inv_number = Appointments::where('Appointment_Status', '!=', 'Failed')
                ->orderBy('id', 'DESC')
                ->pluck('invoice_number')
                ->first();
           
           $inv_number += 1;
            if($request->appoinment_id==''){
        if ($exist != null) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Your already Booked this slot"
                ),
                200
            );
        }
    }
        try {
            $convertedAmount = round(CurrencyConverter::convert($request->fee)
                ->from(auth()->user()->currency_code)
                ->to('INR')
                ->get());

            if ($request->package_id) {
                $packageid = $request->package_id;
            } else {
                $packageid = null;
            }

            if ($request->status == 'Failed' || $request->status == 'Awaiting') {
                $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
                $givenDateTime = date("H:i", strtotime($request->slot));

                $time = $booking_date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);


               
              if($request->appoinment_id==''){
                $appointment = new Appointments();
                $appointment->id = $lastID + 1;
                $appointment->Appointment_Type = $request->call_type;
                $appointment->Appointment_Date = $booking_date;
                $appointment->Appointment_Time = $request->slot;
                $appointment->Appointment_Status = $request->status;
                $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
                $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
                $appointment->therapist_id = $request->therapist;
                $appointment->service_id = $request->service;
                $appointment->slot_id = $request->slot_id;
                $appointment->user_id = auth()->user()->id;
                $appointment->package_id = $packageid;
                $appointment->fee = $convertedAmount;
                $appointment->end_time = date('h:i A', strtotime($closeTime));
                $appointment->payment_status = $status;
                $appointment->invoice_status = 1;
                $appointment->end_datetime = $closeTime;
                $appointment->save();
                }else{
                    $appointment = Appointments::where('id',$request->appoinment_id)->update(
                        [ 'Appointment_Status' => $request->status]
                    ); 
                }
                

                
                Appointments::where('id', $appointment->id)
                    ->update([
                        'session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4'
                    ]);

                if ($appointment) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => "Data saved Successfully",
                            'appointment_id'=>$appointment->id
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'appoinment_id'=>''
                        ),
                        200
                    );
                }
            } else {
              
                if ($request->payment_id) {
                    // $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));
               
                    $api = new Api('rzp_live_eXY8bWSGvN5sgs', 'zYflC5EArb4MkxaoyYRgj4WX');
                    $payment = $api->payment->fetch($request->payment_id);
                
                    $point = WalletPoint::orderBy('id', 'DESC')->first();

                    $amount = $payment['amount'] / 100;
                    $userpoint = $point->point * $amount;
                    $currency = $payment['currency'];
                    $method = $payment['method'];
                    $date = $payment['created_at'];
                    $status = $payment['status'];
                    if ($status == 'authorized') {
                        $payment = $api->payment->fetch($request->payment_id)->capture(array('amount' => $payment['amount'], 'currency' => $currency));
                        $amount = $payment['amount'] / 100;
                        $userpoint = $point->point * $amount;
                        $currency = $payment['currency'];
                        $method = $payment['method'];
                        $date = $payment['created_at'];
                        $status = $payment['status'];
                    }
                    $payment = new PaymentDetails();
                    $payment->user_id = auth()->user()->id;
                    $payment->payment_id = $request->payment_id;
                    $payment->amount_in_currency = $amount;
                    $payment->total_amount_in_rupee = round(CurrencyConverter::convert($amount)
                        ->from($currency)
                        ->to('INR')
                        ->get());
                    $payment->currency = $currency;
                    $payment->payment_method = $method;
                    $payment->payment_date = $date;
                    $payment->payment_status = $status;
                    $payment->save();
                    $paymentid = $payment->id;
                    if ($status == 'captured' || $status = 'authorized') {
                        $status = 'Paid';
                    }
                    if ($convertedAmount != $amount) {
                        $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();

                        $point = WalletPoint::orderBy('id', 'DESC')->first();
                        $userBalance = $userwallet->balance;
                        $userpoint = $point->point * $userBalance;


                        $balance = $userBalance - $userpoint;

                        $userWalletTransaction = new UserWalletTransactions();
                        $userWalletTransaction->user_id = auth()->user()->id;
                        $userWalletTransaction->wallet_id = 1;
                        $userWalletTransaction->type = 'Debit';
                        $userWalletTransaction->amount = $userBalance;
                        $userWalletTransaction->point = $userpoint;
                        $userWalletTransaction->current_balance = $balance;
                        $userWalletTransaction->save();
                        $userWalletTransaction_id = $userWalletTransaction->id;

                        $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                            'user_id' => auth()->user()->id,
                            'balance' => $balance
                        ]);
                    }
                   
                } else {

                    $paymentid = NULL;
                    $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
                    if ($userwallet->balance < $convertedAmount) {
                        return response()->json(
                            array(
                                'status' => false,
                                'data' => "Your wallet account does not have sufficient balance."
                            ),
                            200
                        );
                    }
                    $point = WalletPoint::orderBy('id', 'DESC')->first();
                    $userBalance = $userwallet->balance;
                    $userpoint = $point->point * $convertedAmount;


                    $balance = $userBalance - $userpoint;

                    $userWalletTransaction = new UserWalletTransactions();
                    $userWalletTransaction->user_id = auth()->user()->id;
                    $userWalletTransaction->wallet_id = 1;
                    $userWalletTransaction->type = 'Debit';
                    $userWalletTransaction->amount = $convertedAmount;
                    $userWalletTransaction->point = $userpoint;
                    $userWalletTransaction->current_balance = $balance;
                    $userWalletTransaction->save();
                    $userWalletTransaction_id = $userWalletTransaction->id;
                    if ($userWalletTransaction) {
                        $status = 'Paid';
                    }
                    $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                        'user_id' => auth()->user()->id,
                        'balance' => $balance
                    ]);
                }

                $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
                $givenDateTime = date("H:i", strtotime($request->slot));

                $time = $booking_date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);
                if ($request->follow_up == 1) {

                    $followupdate = Appointments::where('user_id', auth()->user()->id)
                        ->where('follow_up_date', $request->booking_date)
                        ->pluck('id')->first();

                    // if ($followupdate) {
                    //     $res = Appointments::where('id', $followupdate)->update(['follow_up_date' => NULL]);
                    // }
                }
                

        $appointment = Appointments::where('id',$request->appoinment_id)->update(
                    ['payment_id'  => $paymentid,
                        'wallet_trasaction_id'  => $userWalletTransaction_id,
                        'payment_status'  => $status,
                        'invoice_status'  => 1,
                           'invoice_number'  => $inv_number]
                );
                // $appointment = new Appointments();
                // $appointment->id = $lastID + 1;
                // $appointment->Appointment_Type = $request->call_type;
                // $appointment->Appointment_Date = $booking_date;
                // $appointment->Appointment_Time = $request->slot;
                // $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
                // $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
                // $appointment->therapist_id = $request->therapist;
                // $appointment->service_id = $request->service;
                // $appointment->slot_id = $request->slot_id;
                // $appointment->user_id = auth()->user()->id;
                // $appointment->package_id = $packageid;
                // $appointment->fee = $convertedAmount;
                // $appointment->end_time = date('h:i A', strtotime($closeTime));
                // $appointment->payment_id = $paymentid;
                // $appointment->wallet_trasaction_id = $userWalletTransaction_id;
                // $appointment->payment_status = $status;
                // $appointment->invoice_status = 1;
                // $appointment->end_datetime = $closeTime;
                //    $appointment->invoice_number = $inv_number;
                // $appointment->save();

                // Appointments::where('id', $appointment->id)
                //     ->update(['session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4']);
            }

            if ($appointment) {
                $appointment = Appointments::where('id',$request->appoinment_id)->first();
                $therapistname = Therapist::where('id', $request->therapist)->pluck('full_name')->first();

                $data = [
                    'appoinment_id' => $appointment->id
                ];
                $notification = Admin::first();

                #store notification info into notifications table
                $notification->notify(new AppoinmentNotification($data));


                //** push notification */
                PushNotification::create([
                    'title' => 'Booking Alert',
                    'message' => 'Hi, ' . auth()->user()->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with  ' . $therapistname . '. Thank you for visting us ',
                    'therapist_notification' => 'You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . auth()->user()->First_Name . '. ',
                    'type' => 'Appointment',
                    'user_id' => auth()->user()->id,
                    'therapist_id' => $request->therapist,
                    'appoinment_id' =>  $appointment->id
                ]);
                $data = [
                   'token' => auth()->user()->device_token,
                    "notification" => [
                        'title' => 'Yellowcloud Appointment',
                        'body' => 'Hi, ' . auth()->user()->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with  ' . $therapistname . '. Thank you for visting us ',
                        //      'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". "
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data);

                $data2 = [
                   'token' => Therapist::where('id', $request->therapist)->pluck('device_token')->first(),
                    "notification" => [
                        'title' => 'Yellowcloud New Appointment',
                        'body' => 'Hi,  You have a new appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . auth()->user()->First_Name,

                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data2);

                $maildata = [
                    "appintment_id" => $appointment->id,
                    "message" => 'Hi, ' . auth()->user()->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with  ' . $therapistname . '. Thank you for visting us ',
                    "name" => auth()->user()->First_Name
                ];

                // Mail::to(auth()->user()->Email)->send(new BookingMail($maildata));


                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment is Booked Sucessfully"
                    ),
                    200
                );
            } else {

                $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
                $givenDateTime = date("H:i", strtotime($request->slot));

                $time = $booking_date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);
                if($request->appoinment_id){
                    $appointment = Appointments::where('id',$request->appoinment_id)->update(
                        [
                            'payment_status'  => $status,
                            'invoice_status'  => 1,
                            'invoice_number'  => $inv_number]
                    );
                }else{
                    $appointment = new Appointments();
                    $appointment->id = $lastID + 1;
                    $appointment->Appointment_Type = $request->call_type;
                    $appointment->Appointment_Date = $booking_date;
                    $appointment->Appointment_Time = $request->slot;
                    $appointment->Appointment_Status = $request->status;
                    $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
                    $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
                    $appointment->therapist_id = $request->therapist;
                    $appointment->service_id = $request->service;
                    $appointment->slot_id = $request->slot_id;
                    $appointment->user_id = auth()->user()->id;
                    $appointment->package_id = $packageid;
                    $appointment->fee = $convertedAmount;
                    $appointment->end_time = date('h:i A', strtotime($closeTime));
                    $appointment->payment_status = $status;
                    $appointment->invoice_status = 1;
                    $appointment->end_datetime = $closeTime;
                    $appointment->invoice_number = $inv_number;
                    $appointment->save();

            
                Appointments::where('id', $appointment->id)
                    ->update(['session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4']);
                }
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {

            $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);

            if($request->appoinment_id){
                $appointment = Appointments::where('id',$request->appoinment_id)->update([
                        'payment_status'  => $status,
                        'invoice_status'  => 1]
                );
            }else{
            $appointment = new Appointments();
            $appointment->id = $lastID + 1;
            $appointment->Appointment_Type = $request->call_type;
            $appointment->Appointment_Date = $booking_date;
            $appointment->Appointment_Time = $request->slot;
            $appointment->Appointment_Status = $request->status;
            $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
            $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
            $appointment->therapist_id = $request->therapist;
            $appointment->service_id = $request->service;
            $appointment->slot_id = $request->slot_id;
            $appointment->user_id = auth()->user()->id;
            $appointment->package_id = $packageid;
            $appointment->fee = $convertedAmount;
            $appointment->end_time = date('h:i A', strtotime($closeTime));
            $appointment->payment_status = $status;
            $appointment->invoice_status = 1;
            $appointment->end_datetime = $closeTime;
            $appointment->save();

            Appointments::where('id', $appointment->id)
                ->update(['session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4']);
            }
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function previousAppoinments(Request $request)
    {
        try {

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Join')
                ->where('Appointment_Status', '!=', 'No Participants')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                //    $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //     $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //    $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time < $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function upcomingAppoinments(Request $request)
    {


        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();

            foreach ($array as $item) {
                //   $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //   $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //   $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {

                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }

                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }

            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '>', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();

            foreach ($array as $item) {
                //   $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //   $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //   $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {

                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }

                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function upcomingAppoinmentsHomePage(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                if ($key == 2) {
                    break;
                }
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //  $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }


            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '>', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                if ($key == 2) {
                    break;
                }
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //  $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                            if ($payment_details) {
                                $data[$key]['fee'] = $payment_details->amount_in_currency;
                                $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                                $data[$key]['currency_code'] = $payment_details->currency;
                            } else {
                                $data[$key]['fee'] = $item->fee;
                                $data[$key]['currency'] = '₹';
                                $data[$key]['currency_code'] = 'INR';
                            }
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function canceledAppoinments(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', 'Cancel')
                ->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                // $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                        if ($payment_details) {
                            $data[$key]['fee'] = $payment_details->amount_in_currency;
                            $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                            $data[$key]['currency_code'] = $payment_details->currency;
                        } else {
                            $data[$key]['fee'] = $item->fee;
                            $data[$key]['currency'] = '₹';
                            $data[$key]['currency_code'] = 'INR';
                        }
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $payment_details = PaymentDetails::where('id', $item->payment_id)->first();
                    if ($payment_details) {
                        $data[$key]['fee'] = $payment_details->amount_in_currency;
                        $data[$key]['currency'] = Location::where('currency_code', $payment_details->currency)->pluck('currency_symbol')->first();
                        $data[$key]['currency_code'] = $payment_details->currency;
                    } else {
                        $data[$key]['fee'] = $item->fee;
                        $data[$key]['currency'] = '₹';
                        $data[$key]['currency_code'] = 'INR';
                    }
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function addReview(Request $request)
    {
        try {
            if ($request->user_review_id) {
                $review = UserReview::where('id', $request->user_review_id)
                    ->update([
                        'rate' => $request->rate,
                        'comment' => $request->comment
                    ]);
            } else {
                $review = new UserReview();
                $review->therapist_id = $request->therapist_id;
                $review->user_id = auth()->user()->id;
                $review->appoinment_id = $request->appoinment_id;
                $review->rate = $request->rate;
                $review->comment = $request->comment;
                $review->save();
            }
            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Review added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function getReview(Request $request)
    {
        try {

            $review = UserReview::where('appoinment_id', $request->appoinment_id)
                ->where('user_id', auth()->user()->id)
                ->first();

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $review,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function reviewAppoinment(Request $request)
    {
        $review = UserReview::select(DB::raw('avg(rate) as review'))->where('user_id', auth()->user()->id)->get();

        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;
        $data['therapist']->total_sessions = count(Appointments::where('therapist_id', $request->therapist_id)->where('Appointment_Status', 'Completed')->get());
        $data['therapist']->review_average = number_format($review[0]->review, 1);
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function downloadPrescription(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->first();
        $pres = Prescription::where('appoinment_id', $request->appoinment_id)->first();
        if ($pres) {
            $file = asset('assets/uploads/prescription/' . $pres->attachment);
        } else {
            $file = NULL;
        }
        if ($pres) {

            return response()->json(
                array(
                    'status' => true,
                    'link' => $file,
                    'statuscode' => 200
                ),
                200
            );
        } else {

            return response()->json(
                array(
                    'status' => false,
                    'link' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
        // $headers = [
        //     'Content-Type' => 'application/pdf',
        // ];

        // return response()->download($file, 'eConsultation' . $data->user->First_Name . $data->user->Last_Name . ' _00' . $data->id . $data->user->id, $headers);
    }
    public function cancelReason(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->pluck('cancel_reason')->first();

        if ($data) {

            return response()->json(
                array(
                    'status' => true,
                    'reason' => $data,
                    'statuscode' => 200
                ),
                200
            );
        } else {

            return response()->json(
                array(
                    'status' => false,
                    'reason' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function consulation(Request $request)
    {
        $data = ConsulationNote::select('note', 'attachment')->where('appoinment_id', $request->appoinment_id)->first();
        $attachment = NULL;
        if ($data->attachment != NULL) {
            $attachment = asset('assets/uploads/consultation/' . $data->attachment);
        }
        if ($data != null) {
            return response()->json(
                array(
                    'status' => true,
                    'consulation' => $data->note,
                    'attachment' =>  $attachment,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'consulation' => "",
                    'attachment' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
    }
    public function changeAppoinmentStatus(Request $request)
    {

        $data = [
            'appoinment_id' => $request->appoinment_id
        ];
        $notification = Admin::first();

        #store notification info into notifications table
        $notification->notify(new AppoinmentNotification($data));
        try {
            if ($request->status == 'Completed') {
                $commission = TherapistCommission::where('therapist_id', auth()->user()->id)->where('appoinment_id', $request->appoinment_id)->first();
                if ($commission == null) {
                    $appoinment = Appointments::select('fee', 'Appointment_Date')->where('id', $request->appoinment_id)->first();
                    $platformFeePercentage = WalletPointCommission::where('provider_category_id', auth()->user()->provider_category_id)->pluck('commission')->first();
                    $amount = $appoinment->fee;
                    $platformFee = $amount * ($platformFeePercentage / 100);
                    $therapistEarnings = $amount - $platformFee;

                    $tc = new TherapistCommission();
                    $tc->therapist_id = auth()->user()->id;
                    $tc->appoinment_id = $request->appoinment_id;
                    $tc->amount = $amount;
                    $tc->commission = $platformFeePercentage;
                    $tc->platform_fee = $therapistEarnings;
                    $tc->therapist_earnings =  $platformFee;
                    $tc->save();
                }
            }
            if ($request->status == 'Cancel') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date', 'user_id', 'therapist_id')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(6);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Cancel time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'cancel_reason' => $request->reason
                    ]);
                if ($res == 1) {

                    if ($appoinment->user->device_token != NULL) {
                        PushNotification::create([
                            'title' => $request->status . ' Appoinment',
                            'therapist_notification' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " has been " . $request->status . "ed by Patient.",
                            'message' => "Hi, your appointment on yellowcloud   on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " has been " . $request->status . "ed.",
                            'type' => 'Status',
                            'user_id' =>  $appoinment->user->id,
                            'therapist_id' =>  $appoinment->therapist->id,
                            'appoinment_id' =>  $appoinment->id
                        ]);

                        $data = [
                           'token' =>  $appoinment->user->device_token,
                            "notification" => [
                                'title' => $request->status . ' Appoinment',
                                'body' => "Hi, your appointment on yellowcloud   on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " has been " . $request->status . "ed."
                            ],
                            "data" => [
                                "route" => "notification"
                            ]
                        ];
                        sendpushnotification($data);
                        $data1 = [
                           'token' =>  $appoinment->therapist->device_token,
                            "notification" => [
                                'title' => 'Cancel Appoinment',
                                'body' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " has been " . $request->status . "ed by Patient."
                            ],
                            "data" => [
                                "route" => "notification"
                            ]
                        ];

                        sendpushnotification($data1);
                    }
                }

                $point = WalletPoint::orderBy('id', 'DESC')->first();

                $amount = Appointments::where('id', $request->appoinment_id)->pluck('fee')->first();;
                $userpoint = $amount;



                $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
                if ($userwallet == null) {
                    $userBalance = 0;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = new UserWallet();
                    $userwalletadd->user_id = auth()->user()->id;
                    $userwalletadd->balance = $balance;
                    $userwalletadd->save();
                } else {
                    $userBalance = $userwallet->balance;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                        'user_id' => auth()->user()->id,
                        'balance' => $balance
                    ]);
                }

                $userWalletTransaction = new UserWalletTransactions();
                $userWalletTransaction->user_id = auth()->user()->id;
                $userWalletTransaction->wallet_id = 2;
                $userWalletTransaction->type = 'Credit';
                $userWalletTransaction->amount = $amount;
                $userWalletTransaction->point = $userpoint;
                $userWalletTransaction->current_balance = $balance;
                $userWalletTransaction->save();

                if ($userWalletTransaction) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $request->status . " Your appoinment successfully. Refund amount updated to user wallet balance.",
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
            } elseif ($request->status == 'Resheduled') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(6);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Reshedule time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'reshedule_reason' => $request->reason
                    ]);
            } else {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status
                    ]);
            }

            if ($res) {
                if ($appoinment->user->device_token != NULL) {
                    PushNotification::create([
                        'title' => 'Resheduled Appoinment',
                        'therapist_notification' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " .",
                        'message' => "Hi, " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " your appointment on yellowcloud  with " .  $appoinment->therapist->prefix . " " .  $appoinment->therapist->full_name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " .",
                        'type' => 'C',
                        'appoinment_id' =>  $appoinment->id
                    ]);

                    $data = [
                       'token' =>  $appoinment->device_token,
                        "notification" => [
                            'title' => 'Resheduled Appoinment',
                            'body' => "Hi, " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " your appointment on yellowcloud  with " .  $appoinment->therapist->prefix . " " .  $appoinment->therapist->full_name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " ."
                        ],
                        "data" => [
                            "route" => "notification"
                        ]
                    ];
                    sendpushnotification($data);

                    $data1 = [
                       'token' =>  $appoinment->device_token,
                        "notification" => [
                            'title' => 'Resheduled Appoinment',
                            'body' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " ."
                        ],
                        "data" => [
                            "route" => "notification"
                        ]
                    ];
                    sendpushnotification($data1);
                }
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $request->status . " Your appoinment successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function resheduleAppoinment(Request $request)
    {
        try {
            $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date', 'user_id', 'therapist_id')->where('id', $request->appoinment_id)->first();
            $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
            $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
            $checkTime = Carbon::parse($appoinmentTime)->subHours(6);
            $currentDateTime = Carbon::now();

            if ($currentDateTime > $checkTime) {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Reshedule time exceed",
                        'statuscode' => 301
                    ),
                    200
                );
            }

            $duration = Slot::where('therapist_id', $appoinment->therapist_id)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $request->booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);


            $re_appointment = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => date("Y-m-d", strtotime($request->booking_date)),
                'Appointment_Time' => $request->slot,
                'Appointment_Status' => 'Resheduled',
                'slot_id' => $request->slot_id,
                'end_time' => date('h:i A', strtotime($closeTime))
            ]);

            if ($re_appointment) {
                if ($appoinment->user->device_token != NULL) {
                    PushNotification::create([
                        'title' => 'Resheduled Appoinment',
                        'therapist_notification' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " .",
                        'message' => "Hi, " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " your appointment on yellowcloud  with " .  $appoinment->therapist->prefix . " " .  $appoinment->therapist->full_name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " .",
                        'type' => 'C',
                        'appoinment_id' =>  $appoinment->id
                    ]);

                    $data = [
                       'token' =>  $appoinment->device_token,
                        "notification" => [
                            'title' => 'Resheduled Appoinment',
                            'body' => "Hi, " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " your appointment on yellowcloud  with " .  $appoinment->therapist->prefix . " " .  $appoinment->therapist->full_name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " ."
                        ],
                        "data" => [
                            "route" => "notification"
                        ]
                    ];
                    sendpushnotification($data);

                    $data1 = [
                       'token' =>  $appoinment->device_token,
                        "notification" => [
                            'title' => 'Resheduled Appoinment',
                            'body' => "Hi,  your appointment on yellowcloud  with " .  $appoinment->user->First_Name . "  " .  $appoinment->user->Last_Name . " has been Resheduled on " .  $appoinment->Appointment_Date . " at " .  $appoinment->Appointment_Time . " ."
                        ],
                        "data" => [
                            "route" => "notification"
                        ]
                    ];
                    sendpushnotification($data1);
                }
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment resheduled Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }
}
